<?php $__env->startSection('title', 'Module'); ?>
<?php
$users = \Auth::user();
$currantLang = $users->currentLanguage();
?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?php echo e(__('Create Language')); ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Dashboard')); ?></a></div>
                <div class="breadcrumb-item"><a href="<?php echo e(route('manage.language',[$currantLang])); ?>"><?php echo e(__('Languages')); ?></a></div>
                <div class="breadcrumb-item"><?php echo e(__('Create')); ?></div>
            </div>
        </div>
        <div class="section-body">
            <form class="form-horizontal" method="POST" action="<?php echo e(route('store.language')); ?>">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-xl-6 mx-auto order-xl-1">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="heading-small text-muted mb-4"><?php echo e(__('Create Language')); ?></h6>
                                <div class="pl-lg-4">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <?php echo e(Form::label('code', __('Language Code'))); ?>

                                                <?php echo e(Form::text('code', '', ['class' => 'form-control', 'required' => 'required'])); ?>

                                                <?php if($errors->has('code')): ?>
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong><?php echo e($errors->first('code')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>


                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class=" mt-4 ">
                                    <button type="submit"
                                        class="btn btn-primary col-md-3 float-right "><?php echo e(__('Create Language')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\virtual_card\resources\views/lang/create.blade.php ENDPATH**/ ?>