<?php $__env->startSection('title', __('Card Transactions')); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?php echo e(__('Card Transactions')); ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>">Dashboard</a></div>
                <div class="breadcrumb-item"><?php echo e(__('Card Transactions')); ?></div>
            </div>
        </div>
        <div class="section-body">
            <div class="row ">
                <div class="col-12">
                    <div class="card p-3">
                        <div class="table table-striped dataTable no-footer">
                            <table class="table table-striped data-table">
                                <thead>
                                    <tr>

                                        <th><?php echo e(__('Amount')); ?></th>
                                        <th><?php echo e(__('Date')); ?></th>
                                        <th><?php echo e(__('Transaction reference')); ?></th>
                                        <th><?php echo e(__('Currency')); ?></th>
                                        <th><?php echo e(__('Type')); ?></th>
                                        <th><?php echo e(__('Description')); ?></th>
                                        <th width="105px"><?php echo e(__('Action')); ?></th>

                                    </tr>
                                </thead>

                                <tbody>
                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
<?php echo $__env->make('layouts.includes.datatable_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
    .error_red {
        width: 100%;
        margin-top: 0.25rem;
        font-size: 80%;
        color: #dc3545;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('javascript'); ?>
<?php echo $__env->make('layouts.includes.datatable_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script type="text/javascript">
    $(function() {

        var table = $('.data-table').DataTable({

            processing: true,
            serverSide: true,
            ajax: {
                url: "<?php echo e(url('/card-transaction/')); ?>/<?php echo e($card_id); ?>",
                type: 'GET',
            },
            columns: [{
                    data: 'amount',
                    name: 'amount',
                    render: function(data, type, full, meta) {
                        if (full['card_transaction_type'] == 'CREDIT') {
                            return '<svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg"><path opacity="0.5" d="M9.25479 19.6025C8.76663 20.0907 8.76663 20.8821 9.25479 21.3703C9.74294 21.8584 10.5344 21.8584 11.0226 21.3703L21.6292 10.7637C22.1173 10.2755 22.1173 9.48405 21.6292 8.9959C21.141 8.50774 20.3495 8.50774 19.8614 8.9959L9.25479 19.6025Z" fill="#3699FF"></path><path d="M19.8616 20.1202C20.5519 20.1202 21.1116 20.6799 21.1116 21.3703C21.1116 22.0606 20.5519 22.6203 19.8616 22.6203H9.25495C8.58571 22.6203 8.0352 22.0932 8.00613 21.4245L7.56419 11.2599C7.5342 10.5702 8.06901 9.98676 8.75871 9.95677C9.44842 9.92678 10.0318 10.4616 10.0618 11.1513L10.4518 20.1202H19.8616Z" fill="#3699FF"></path></svg> <?php echo e(Utility::getValByName('currency_symbol ')); ?>' + data / 100;
                        } else {
                            return '<svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg"><title>Unload card</title><desc>Unload card</desc><path opacity="0.5" d="M20.7452 10.3971C21.2334 9.90898 21.2334 9.11752 20.7452 8.62937C20.2571 8.14121 19.4656 8.14121 18.9774 8.62937L8.37084 19.236C7.88268 19.7241 7.88268 20.5156 8.37084 21.0037C8.859 21.4919 9.65045 21.4919 10.1386 21.0037L20.7452 10.3971Z" fill="#FFA800"></path><path d="M10.1384 9.87938C9.44809 9.87938 8.88844 9.31974 8.88844 8.62938C8.88844 7.93903 9.44809 7.37938 10.1384 7.37938L20.745 7.37938C21.4143 7.37938 21.9648 7.90648 21.9939 8.57509L22.4358 18.7397C22.4658 19.4295 21.931 20.0129 21.2413 20.0429C20.5516 20.0729 19.9682 19.538 19.9382 18.8483L19.5482 9.87938L10.1384 9.87938Z" fill="#FFA800"></path></svg> <?php echo e(Utility::getValByName('currency_symbol ')); ?>' + data / 100;
                        }
                    },
                },
                {
                    data: 'transaction_date',
                    name: 'date time',
                    title: 'Date & Time'

                },
                {
                    data: 'client_transaction_reference',
                    name: 'client_transaction_reference'
                },
                {
                    data: 'currency',
                    name: 'currency'
                },
                {
                    data: 'card_transaction_type',
                    name: 'card_transaction_type',
                    render: function(data, type, full, meta) {
                        if (full['card_transaction_type'] == 'CREDIT') {
                            return '<label class="badge badge-primary">' + data + '</label>';
                        } else {
                            return '<label class="badge badge-danger">' + data + '</label>';
                        }
                    },

                },
                {
                    data: 'description',
                    name: 'description',

                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false,
                    render: function(data, type, full, meta) {
                        return '<a class="btn-sm btn btn-success view-details" data-toggle="tooltip" data-placement="left" title="" href="javascript:void(0)" data-id="10" data-url="<?php echo e(url('transaction-details')); ?>/<?php echo e($card_id); ?>/'+full['client_transaction_reference']+'" data-original-title="Details"><i class="fa fa-info-circle"></i></a>';
                    },

                },


            ],


            "language": {
                "paginate": {
                    "next": "<i class=\"fas fa-angle-right\"><\/i>",
                    "previous": "<i class=\"fas fa-angle-left\"><\/i>"
                }
            },

            "lengthMenu": [
                [5, 15, 25, 100, -1],
                [5, 15, 25, 100, "All"]
            ],
            paging: true,
            "pageLength": 20,

        });

    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\virtual_card\resources\views/cards/trasactions.blade.php ENDPATH**/ ?>