<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Cities;
use App\Models\User;
use Illuminate\Http\Request;
use CinetPay\CinetPay;

class ApiController extends Controller
{

    public function mobileCheck(Request $request)
    {
        dd('jkjkhere');
        $validator = \Validator::make($request->all(), [
            'country_code' => 'required',
            'mobile' => 'required',
        ]);
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return response()->json([
                'is_success' => false,
                'data' => ['message' => $messages->first()],
            ], 200);
        }

        $exist_mobile = User::where('mobile', $request->mobile)->first();

        if($exist_mobile){
            $exist_mobile->otp = 123456;
            $exist_mobile->save();
           
       
            if (Auth::login($exist_mobile)) {
                return response()->json(['is_success' => true, 'message' => 'Otp send sucessfully', 'data' => $exist_mobile], 200);
            } else {
                return response()->json(['is_success' => false, 'message' => __('user not Found')], 200);
            }
    }
}

    public function register(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'first_name' => 'required',
            'last_name' => 'required',
            'company_name' => 'required',
            'email' => 'required',
            'phone_no' => 'required'
        ]);
        if ($validate->fails()) {
            return response()->json(['ResponseCode' => '0', 'ResponseText' => 'Validation fail', 'ResponseData' => ['errors' => $validate->errors()->all()]], 499);
        }
        $user = new User();
        $user->first_name = $request->first_name;
        $user->last_name = $request->last_name;
        $user->email = $request->email;
        $user->company_name = $request->company_name;
        $user->phone_no = $request->phone_no;
        $user->save();

        if ($user) {
            return response()->json(['is_success' => true, 'message' => 'user created sucessfully', 'data' => $user], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => __('user not Found')], 200);
        }
    }

    public function getProfile($id)
    {
        $user_details = User::where('id', $id)->get()->first();

        if ($user_details) {
            return response()->json(['is_success' => true, 'message' => 'user created sucessfully', 'data' => $user], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => __('user not Found')], 200);
        }
    }

    public function documentVerification(Request $request, $id)
    {
        $user = User::find($id);
        //---------------------For document 1-------------------------
        if ($request->hasFile('document_1')) {
            $filenameWithExt = $request->file('document_1')->getClientOriginalName();
            $filename        = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $extension       = $request->file('document_1')->getClientOriginalExtension();
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;
            $dir             = storage_path('documents/');

            if (!file_exists($dir)) {

                mkdir($dir, 0777, true);
            }
            $path = $request->file('document_1')->storeAs('documents/', $fileNameToStore);
        }

        if (!empty($request->document_1)) {
            $user->document_1 = $fileNameToStore;
        }

        //---------------------For document 2-------------------------
        if ($request->hasFile('document_2')) {
            $filenameWithExt = $request->file('document_2')->getClientOriginalName();
            $filename        = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $extension       = $request->file('document_2')->getClientOriginalExtension();
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;
            $dir             = storage_path('documents/');

            if (!file_exists($dir)) {

                mkdir($dir, 0777, true);
            }
            $path = $request->file('document_2')->storeAs('documents/', $fileNameToStore);
        }

        if (!empty($request->document_2)) {
            $user->document_2 = $fileNameToStore;
        }

        $user->status = 0;
        $user->save();

        if ($user) {
            return response()->json(['is_success' => true, 'message' => 'document verification uploaded sucessfully', 'data' => $user], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => __('user not Found')], 200);
        }
    }

    public function cities()
    {
        $cities = Cities::select('id','name')->get();

        if ($cities) {
            return response()->json(['is_success' => true, 'message' => 'Cities get sucessfully', 'data' => $cities], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => __('plan not Found')], 200);
        }
    }

    public function changePassword(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'current_password' => 'required',
            'new_password' => 'required|min:6',
            'confirm_password' => 'required|same:new_password',
        ]);

        $objUser          = Auth::user();
        $request_data     = $request->All();
        $current_password = $objUser->password;
        if (Hash::check($request_data['current_password'], $current_password)) {
            $user_id            = Auth::User()->id;
            $obj_user           = User::find($user_id);
            $obj_user->password = Hash::make($request_data['new_password']);;
            $obj_user->save();

            return redirect()->route('profile', $objUser->id)->with('success', __('Password successfully updated.'));
        } else {
            return redirect()->route('profile', $objUser->id)->with('error', __('old Password does not match.'));
        }
    }
}
