<?php

namespace App\Http\Controllers;

use App\Facades\UtilityFacades;
use App\Models\Fund_request;
use App\Models\Tournament;
use App\Models\Tournament_participants;
use App\Models\User;
use App\Models\Withdraw_request;
use Illuminate\Http\Request;
use PaytmWallet;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
            $usercount = User::where('type','User')->count();
            $admincount = User::where('type','Admin')->count();
            return view('dashboard.home',compact('usercount', 'admincount'));
        
    }

    public function front()
    {

        return view('front.home');
    }

    public function manageWallet()
    {

        return view('front.wallet');
    }

    function order(Request $request){

        $input = $request->all();
        $user = auth()->user();

        $payment = PaytmWallet::with('receive');
        $payment->prepare([
            'order' => $input['order_id'],
            'user' => $input['CUST_ID'],
            'mobile_number' => $user->mobile,
            'email' => $user->email,
            'amount' => $input['amount'],
            'callback_url' => url('api/paytm-payment-status')
        ]);
        return $payment->receive();
    }

    public function join($id)
    {
        $tournament = Tournament::find($id);
        if ($tournament) {
            $user = auth()->user();
            if ($tournament->fees > $user->balance) {
                return redirect('/games/bgmi#upcoming-matches')->with('error', 'Insufficient Balance..!');
            } else {
                $join_details = Tournament_participants::where('match_id', $id)
                    ->where('user_id', $user->id)
                    ->first();
                $participants = Tournament_participants::where('match_id', $id)->get();
                return view('front.tournament-details', compact('tournament', 'join_details', 'participants'));
            }
        } else {
            return redirect()->back()->with('error', 'Tournament Not Exist.');
        }
    }

    function joinTournament(Request $request)
    {
        request()->validate([
            'ign' => 'required',
        ]);

        $user = auth()->user();
        $tournament = Tournament::find($request->match_id);
        if ($tournament) {
            if ($tournament->fees > $user->balance) {
                return redirect('/games/bgmi#upcoming-matches')->with('error', 'Insufficient Balance..!');
            }
            $participant = Tournament_participants::create(['ign' => $request->ign, 'match_id' => $request->match_id, 'user_id' => $user->id]);


            return redirect('/games/bgmi#upcoming-matches')
                ->with('success', __('Join successfully.'));
        } else {
            return redirect()->back()->with('error', 'Tournament Not Exist.');
        }
    }
}
