@php
    $user = \Auth::user();
@endphp
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">

<head>
    <title>Bitrader - Professional Multipurpose HTML Template for Your Crypto, Forex, and Stocks Trading Business </title>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="{{ asset('assets/front/js/jquery-3.5.1.slim.min.js') }}" ></script>
    <script src="{{ asset('assets/front/js/bootstrap.bundle.min.js') }}" ></script>
    <script defer src="{{ asset('assets/front/js/popper.min.js') }}" ></script>
    <script src="{{ asset('assets/front/js/bootstrap.min.js') }}" ></script>
    <link rel="stylesheet" href="{{ asset('assets/front/css/bootstrap.min.css') }}" >
    <link rel="stylesheet" href="{{ asset('assets/front/css/owl.carousel.min.css') }}"/>
    <link rel="stylesheet" href="{{ asset('assets/front/css/owl.theme.default.min.css') }}"  />
    <script src="{{ asset('assets/front/js/kit.fontawesome.js') }}" crossorigin="anonymous"></script>

    <meta name="application-name" content="Bitrader - Professional Multipurpose HTML Template for Your Crypto, Forex, and Stocks Trading Business">
    <meta name="author" content="thetork">
    <meta name="keywords" content="Bitrader, Crypto, Forex, and Stocks Trading Business">
    <meta name="description" content="Experience the power of Bitrader, the ultimate HTML template designed to transform your trading business. With its sleek design and advanced features, Bitrader empowers you to showcase your expertise, engage clients, and dominate the markets. Elevate your online presence and unlock new trading possibilities with Bitrader.">

    <!-- OG meta data -->
    <meta property="og:title" content="Bitrader - Professional Multipurpose HTML Template for Your Crypto, Forex, and Stocks Trading Business">
    <meta property="og:site_name" content=Bitrader>
    <meta property="og:url" content="index-2.html">
    <meta property="og:description" content="Welcome to Bitrader, the game-changing HTML template meticulously crafted to revolutionize your trading business. With its sleek and modern design, Bitrader provides a cutting-edge platform to showcase your expertise, attract clients, and stay ahead in the competitive trading markets.">
    <meta property="og:type" content="website">
    <meta property="og:image" content="{{ asset('assets/front/images/og.png') }}">



    <link rel="shortcut icon" href="{{ asset('assets/front/images/favicon.png') }}"" type="image/x-icon">

    <link rel="stylesheet" href="{{ asset('assets/front/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/front/css/aos.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/front/css/all.min.css') }}">

    <link rel="stylesheet" href="{{ asset('assets/front/css/swiper-bundle.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/front/css/style.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/modules/izitoast/css/iziToast.min.css ') }}">
    <script type="text/javascript">
        var SITE_URL = "{{ route('front') }}";
    </script>

      <style>
        .banner__content-heading {
            color: #213654;
            font-size: 35px;
            line-height: 50px;
            font-family: 'Open Sans', sans-serif;
        }
        
        .span01 {
            color: #177591;
        }
        
        .banner__content-moto {
            color: #001839;
            font-size: 16px;
            line-height: 25px;
            margin-top: 10px;
        }
        
        .ma01 {
            color: #323f4b;
        }
        
        .heading02 {
            color: #000;
            letter-spacing: 1px;
        }
    </style>
</head>

<body>
     <!-- ===============>> Preloader start here <<================= -->
    <div class="preloader">
        <img src="{{ asset('assets/front/images/logo/preloader.png') }}" alt="preloader icon">
    </div>
    <!-- ===============>> Preloader end here <<================= -->

     <!-- ===============>> light&dark switch start here <<================= -->
    <div class="lightdark-switch">
       <span class="dark-btn" id="btnSwitch"><img src="{{ asset('assets/front/images/icon/moon.svg') }}" alt="light-dark-switchbtn"
        class="swtich-icon"></span>
    </div>
    <!-- ===============>> light&dark switch start here <<================= -->

 <!-- ===============>> Header section start here <<================= -->
    <header class="header-section {{ request()->routeIs('front') ? 'header-section--style2' : 'bg-color-3' }} ">
        <div class="header-bottom">
            <div class="container">
                <div class="header-wrapper">
                    <div class="logo">
                        <a href="{{ route('front') }}">
                            <img class="dark" src="{{ asset('assets/front/images/logo/logo.png') }}" alt="logo">
                        </a>
                    </div>
                    <div class="menu-area">
                        <ul class="menu menu--style1">

                            <li><a href="{{ route('front') }}">Home</a></li>


                            <li>
                                <a href="{{ route('services') }}">Services</a>
                            </li>



                            <li>
                                <a href="{{ route('aboutus') }}">About Us</a>
                            </li>


                            <!-- <li>
                <a href="#0">Pages</a>
                <ul class="submenu">
                  <li><a href="blogs.html">Blogs</a></li>
                  <li><a href="blog-sidebar.html">Blog - Side Bar</a></li>
                  <li><a href="blog-details.html">Blog Details</a></li>
                  <li><a href="signup.html">Sign Up</a></li>
                  <li><a href="signup-2.html">Sign Up 2</a></li>
                  <li><a href="signin.html">Sign In</a></li>
                  <li><a href="signin-2.html">Sign In 2</a></li>
                  <li><a href="forgot-pass.html">Reset Password</a></li>
                  <li><a href="forgot-pass-2.html">Reset Password 2</a></li>
                  <li><a href="404.html">404 Error</a></li>
                </ul>

              </li> -->
                            <li>
                                <a href="{{route('contactus')}}">Contact Us</a>
                            </li>
                        </ul>

                    </div>
                    <div class="header-action">
                        <div class="menu-area">
                            <div class="header-btn">
                                <a href="{{route('user-login')}}" class="trk-btn trk-btn--border trk-btn--primary">
                                    <span>Sign In</span>
                                </a>
                                <a href="{{route('user-register')}}" class="trk-btn trk-btn--border trk-btn--primary">
                                    <span>Sign Up</span>
                                </a>
                            </div>

                            <!-- toggle icons -->
                            <div class="header-bar d-lg-none header-bar--style1">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- ===============>> Header section end here <<================= -->




    @yield('content')


    <!-- ===============>> footer start here <<================= -->
    <footer class="footer brand-1">
        <div class="container">
            <div class="footer__wrapper">
                <div class="footer__top footer__top--style1">
                    <div class="row gy-5 gx-4">
                        <div class="col-md-6">
                            <div class="footer__about">
                                <a href="{{ route('front') }}" class="footer__about-logo"><img src="{{ asset('assets/front/images/logo/logo-dark.png') }}" alt="Logo"></a>
                                <p class="footer__about-moto ">Welcome to our trading site! We offer the best, most affordable products and services around. Shop now and start finding great deals!</p>
                                <div class="footer__app">
                                    <div class="footer__app-item footer__app-item--apple">
                                        <div class="footer__app-inner">
                                            <div class="footer__app-thumb">
                                                <a href="https://www.apple.com/app-store/" target="_blank" class="stretched-link">
                                                    <img src="{{ asset('assets/front/images/footer/apple.png') }}" alt="apple-icon">
                                                </a>
                                            </div>
                                            <div class="footer__app-content">
                                                <span>Download on the</span>
                                                <p class="mb-0">App Store</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="footer__app-item footer__app-item--playstore">
                                        <div class="footer__app-inner">
                                            <div class="footer__app-thumb">
                                                <a href="https://play.google.com/store" target="_blank" class="stretched-link">
                                                    <img src="{{ asset('assets/front/images/footer/play.png') }}" alt="playstore-icon">
                                                </a>
                                            </div>
                                            <div class="footer__app-content">
                                                <span>GET IT ON</span>
                                                <p class="mb-0">Google Play</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-4 col-6">
                            <div class="footer__links">
                                <div class="footer__links-tittle">
                                    <h6>Quick links</h6>
                                </div>
                                <div class="footer__links-content">
                                    <ul class="footer__linklist">
                                        <li class="footer__linklist-item"> <a href="{{route('aboutus')}}">About Us</a>
                                        </li>
                                        <li class="footer__linklist-item"> <a href="#">Teams</a>
                                        </li>
                                        <li class="footer__linklist-item"> <a href="{{route('services')}}">Services</a> </li>
                                        <li class="footer__linklist-item"> <a href="#">Features</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                        </div>
                        <div class="col-md-2 col-sm-4 col-6">
                            <div class="footer__links">
                                <div class="footer__links-tittle">
                                    <h6>Support</h6>
                                </div>
                                <div class="footer__links-content">
                                    <ul class="footer__linklist">
                                        <li class="footer__linklist-item"> <a href="#">Terms & Conditions</a>
                                        </li>
                                        <li class="footer__linklist-item"> <a href="#">Privacy Policy</a>
                                        </li>
                                        <li class="footer__linklist-item"> <a href="#">FAQs</a></li>
                                        <li class="footer__linklist-item"> <a href="#">Support Center</a> </li>
                                    </ul>
                                </div>
                            </div>

                        </div>
                        <div class="col-md-2 col-sm-4">
                            <div class="footer__links">
                                <div class="footer__links-tittle">
                                    <h6>Company</h6>
                                </div>
                                <div class="footer__links-content">
                                    <ul class="footer__linklist">
                                        <li class="footer__linklist-item"> <a href="#">Careers</a>
                                        </li>
                                        <li class="footer__linklist-item"> <a href="#">Updates</a>
                                        </li>
                                        <li class="footer__linklist-item"> <a href="#">Job</a> </li>
                                        <li class="footer__linklist-item"> <a href="#">Announce</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="footer__bottom">
                    <div class="footer__end">
                        <div class="footer__end-copyright">
                            <p class=" mb-0">© 2023 All Rights Reserved By <a href="https://themeforest.net/user/thetork/portfolio" target="_blank">Thetork</a> </p>
                        </div>
                        <div>
                            <ul class="social">
                                <li class="social__item">
                                    <a href="#" class="social__link social__link--style22"><i class="fab fa-facebook-f"></i></a>
                                </li>
                                <li class="social__item">
                                    <a href="#" class="social__link social__link--style22 "><i class="fab fa-instagram"></i></a>
                                </li>
                                <li class="social__item">
                                    <a href="#" class="social__link social__link--style22"><i class="fa-brands fa-linkedin-in"></i></a>
                                </li>
                                <li class="social__item">
                                    <a href="#" class="social__link social__link--style22"><i class="fab fa-youtube"></i></a>
                                </li>
                                <li class="social__item">
                                    <a href="#" class="social__link social__link--style22 "><i class="fab fa-twitter"></i></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer__shape">
            <span class="footer__shape-item footer__shape-item--1"><img src="{{ asset('assets/front/images/footer/1.png') }}"
          alt="shape icon"></span>
            <span class="footer__shape-item footer__shape-item--2"> <span></span> </span>
        </div>
    </footer>
    <!-- ===============>> footer end here <<================= -->



    <!-- ===============>> scrollToTop start here <<================= -->
    <a href="#" class="scrollToTop scrollToTop--home1"><i class="fa-solid fa-arrow-up-from-bracket"></i></a>
    <!-- ===============>> scrollToTop ending here <<================= -->


    <!-- vendor plugins -->

    <script src="{{ asset('assets/front/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/all.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/swiper-bundle.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/aos.js') }}"></script>
    <script src="{{ asset('assets/front/js/fslightbox.js') }}"></script>
    <script src="{{ asset('assets/front/js/purecounter_vanilla.js') }}"></script>



    <script src="{{ asset('assets/front/js/custom.js') }}"></script>

    <script src="{{ asset('assets/modules/izitoast/js/iziToast.min.js') }}"></script>

    


    {{-- @include('layouts.includes.alerts') --}}
    <script>
        
        @if (session('errors'))
            iziToast.error({
                title: '{{ __('Error!') }}',
                message: "{{ session('errors') }}",
                position: 'topRight'
            });
        @endif

        @if (session('successful'))
            iziToast.success({
                title: '{{ __('Success') }}',
                message: '{{ session('successful') }}',
                position: 'topRight'
            });
        @endif

        @if (session('success'))
            iziToast.success({
                title: '{{ __('Success') }}',
                message: '{{ session('success') }}',
                position: 'topRight'
            });
        @endif
    </script>
</body>

</html>
