@extends('layouts.admin')
@section('title', 'Users')
@section('content')
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Create User</h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="{{ route('home') }}">Dashboard</a></div>
                    <div class="breadcrumb-item active"><a href="{{ route('users.index') }}">Users</a></div>
                    <div class="breadcrumb-item">Create User</div>
                </div>
            </div>
            <div class="section-body">
                <div class="row">
                    <div class="col-md-8 m-auto">
                        <div class="card p-4">
                            {!! Form::open(['route' => 'users.store', 'method' => 'Post', 'enctype' => 'multipart/form-data']) !!}
                            <div class="row">
                                <div class="form-group col-md-6">
                                    {{ Form::label('name', __('Name')) }}
                                    <div class="input-group ">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fas fa-user"></i>
                                            </div>
                                        </div>
                                        {!! Form::text('name', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Name']) !!}
                                    </div>
                                </div>
                                <div class="form-group col-md-6 ">
                                    {{ Form::label('user_id', __('User ID')) }}
                                    <div class="input-group ">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fas fa-user"></i>
                                            </div>
                                        </div>
                                        {!! Form::text('user_id', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter User ID']) !!}
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-6">
                                    {{ Form::label('email', __('Email')) }}
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fas fa-envelope"></i>
                                            </div>
                                        </div>
                                        {!! Form::text('email', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Email Address']) !!}
                                    </div>
                                </div>
                                <div class="form-group col-md-6 ">
                                    {{ Form::label('mobile_number', __('Mobile Number')) }}
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fas fa-phone"></i>
                                            </div>
                                        </div>
                                        {!! Form::text('mobile_number', null, [
                                            'class' => 'form-control',
                                            ' required',
                                            'placeholder' => 'Enter Mobile Number',
                                        ]) !!}
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-6">
                                    {{ Form::label('password', __('Password')) }}
                                    <div class="input-group ">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fas fa-lock"></i>
                                            </div>
                                        </div>
                                        {!! Form::password('password', ['class' => 'form-control', ' required', 'placeholder' => 'Enter  Password']) !!}
                                    </div>
                                </div>
                                <div class="form-group col-md-6 ">
                                    {{ Form::label('confirm-password', __('Confirm Password')) }}
                                    <div class="input-group ">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fas fa-lock"></i>
                                            </div>
                                        </div>
                                        {{ Form::password('confirm-password', ['class' => 'form-control', ' required', 'placeholder' => 'Enter Confirm Password']) }}
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col-md-6">
                                    {{ Form::label('account_number', __('Account Number')) }}
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fa fa-piggy-bank"></i>
                                            </div>
                                        </div>
                                        {!! Form::text('account_number', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Account Number']) !!}
                                    </div>
                                </div>
                                <div class="form-group col-md-6 ">
                                    {{ Form::label('ifsc_code', __('IFSC Code')) }}
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fa fa-code-branch"></i>
                                            </div>
                                        </div>
                                        {!! Form::text('ifsc_code', null, [
                                            'class' => 'form-control',
                                            ' required',
                                            'placeholder' => 'Enter IFSC Code',
                                        ]) !!}
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-6">
                                    {{ Form::label('adhar_number', __('Adhar Number')) }}
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fa fa-credit-card"></i>
                                            </div>
                                        </div>
                                        {!! Form::text('adhar_number', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Adhar Number']) !!}
                                    </div>
                                </div>
                                <div class="form-group col-md-6 ">
                                    {{ Form::label('pan_number', __('Pan number')) }}
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fa fa-credit-card"></i>
                                            </div>
                                        </div>
                                        {!! Form::text('pan_number', null, [
                                            'class' => 'form-control',
                                            ' required',
                                            'placeholder' => 'Enter Pan number',
                                        ]) !!}
                                    </div>
                                </div>
                            </div>
                            
                             <div class="row">
                                <div class="form-group col-md-4">
                                    {{ Form::label('total_fund', __('Total Fund')) }}
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fa fa-rupee-sign"></i>
                                            </div>
                                        </div>
                                        {!! Form::number('total_fund', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Total Fund']) !!}
                                    </div>
                                </div>
                                <div class="form-group col-md-4 ">
                                    {{ Form::label('profit', __('Profit')) }}
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fa fa-rupee-sign"></i>
                                            </div>
                                        </div>
                                        {!! Form::number('profit', null, [
                                            'class' => 'form-control',
                                            ' required',
                                            'placeholder' => 'Enter Profit',
                                        ]) !!}
                                    </div>
                                </div>
                                <div class="form-group col-md-4 ">
                                    {{ Form::label('loss', __('Loss')) }}
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fa fa-rupee-sign"></i>
                                            </div>
                                        </div>
                                        {!! Form::number('loss', null, [
                                            'class' => 'form-control',
                                            ' required',
                                            'placeholder' => 'Enter Loss',
                                        ]) !!}
                                    </div>
                                </div>
                                  <div class="form-group col-md-4">
                                {{ Form::label('roles', __('Role')) }}
                                <div class="input-group ">

                                    {!! Form::select('roles', $roles, null, ['class' => 'form-control']) !!}
                                </div>
                            </div>
                            </div>

                            
                            <div class="btn-flt">
                                <a href="{{ route('users.index') }}" class="btn btn-secondary">{{ __('Cancel') }}</a>
                                <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
                            </div>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
