<?php


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Api\UserController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::post('/check-mobile', [UserController::class, 'mobileCheck'])->name('check-mobile');
Route::post('register', [UserController::class, 'register'])->name('register');
Route::post('login', [UserController::class, 'login'])->name('login');
Route::get('cities', [ApiController::class, 'cities'])->name('cities');

Route::group(
    ['middleware' => 'auth:api'],
    function () {
        Route::post('/home', [UserController::class, 'home']);
        Route::post('/update_profile', [CustomerController::class, 'update_profile']);
        Route::post('/change_password', [CustomerController::class, 'change_password']);
        Route::get('get-profile/{id}', [ApiController::class, 'getProfile'])->name('getProfile');
        Route::POST('document-verification/{id}', [ApiController::class, 'documentVerification'])->name('documentVerification');
        Route::POST('change-password', [ApiController::class, 'changePassword'])->name('changePassword');
        Route::get('plan-list', [ApiController::class, 'planList'])->name('planList');
    }
);

