<?php $__env->startSection('title', 'My Profile'); ?>
<?php $__env->startSection('content'); ?>
   <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Profile')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Dashboard')); ?></a></div>
                    <div class="breadcrumb-item"><?php echo e(__('Profile')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body text-center">
                                <div class="row">
                                    <div id="avatar-holder" class="col-md-12">
                                        <img id="avatar-img" class="img profile-user-img img-responsive img-circle avtar"
                                            src="<?php echo e($user->avatar ? Storage::url($user->avatar) : asset('uploads/avatar/avatar.png')); ?>"
                                            alt="User profile picture">
                                        <h5 class="mt-3 mb-0"><b><?php echo e($user->name); ?></b></h5>
                                        <p><?php echo e($user->email); ?></p>
                                        <span class="mt-3 mb-0 d-block">
                                            <p>
                                                <b><?php echo e(__('Role:')); ?></b>
                                                <?php echo e($role ? $role->name : 'Role Not Set'); ?>

                                            </p>
                                        </span>
                                        <span class="mt-0 d-block">
                                            <p><b><?php echo e(__('Joined:')); ?></b>
                                                <?php echo e($user->created_at); ?>

                                            </p>
                                        </span>
                                        <?php if(\Auth::user()->social_type != null): ?>
                                            <span class="mt-0 d-block">
                                                <p><b><?php echo e(__('Login With:')); ?></b>
                                                    <?php echo e(ucfirst($user->social_type)); ?>

                                                </p>
                                            </span>
                                        <?php endif; ?>
                                        <label class="btn btn-primary btn-lg d-block mx-auto mt-5 col-sm-12 mb-0"
                                            for="avatarCrop">
                                            <?php echo e(__('Update Avatar')); ?>

                                            <input type="file" class="d-none" id="avatarCrop">
                                        </label>
                                    </div>
                                    <div id="avatar-updater" class="col-xs-12 d-none">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="image-preview"></div>
                                            </div>
                                            <div class="col-md-12">
                                                <input type="text" name="avatar-url" class="d-none"
                                                    value="<?php echo e(route('update-new-avatar', Auth::user()->id)); ?>">
                                                <button type="button" id="rotate-image"
                                                    class="btn btn-info col-sm-12 mb-1"><?php echo e(__('Rotate Image')); ?></button>
                                                <button type="button" id="crop_image"
                                                    class="btn btn-primary col-sm-12"><?php echo e(__('Crop Image')); ?></button>
                                                <button type="button" id="avatar-cancel-btn" name="button"
                                                    class="btn btn-primary col-sm-12 mt-1"><?php echo e(__('Cancel')); ?></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-body">
                                <ul class="nav nav-tabs" id="myTab" role="tablist">
                                    <li class="nav-item shadow mb-3 mr-2">
                                        <a class="nav-link active" id="account-details-tab" data-toggle="tab"
                                            href="#account-details" role="tab" aria-controls="account-details"
                                            aria-selected="false"><?php echo e(__('Account Details')); ?></a>
                                    </li>
                                    <li class="nav-item shadow mb-3 mr-2">
                                        <a class="nav-link" id="login-details-tab" data-toggle="tab"
                                            href="#login-details" role="tab" aria-controls="login-details"
                                            aria-selected="false"><?php echo e(__('Login Details')); ?></a>
                                    </li>
                                    <?php if(extension_loaded('imagick') && Utility::getsettings('2fa')): ?>
                                        <li class="nav-item shadow mb-3 mr-2">
                                            <a class="nav-link" id="tfa-settings-tab" data-toggle="tab"
                                                href="#tfa-settings" role="tab" aria-controls="tfa-settings"
                                                aria-selected="false"><?php echo e(__('Two Factor Auth')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                                <div class="tab-content mt-3 mx-0">
                                    <div class="tab-pane active" id="account-details" role="tabpanel"
                                        aria-labelledby="account-details-tab">
                                        <form class="form-horizontal" method="POST"
                                            action="<?php echo e(route('profile.update', $user->id)); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('put'); ?>
                                            <div class="row form-group">
                                                <div class="col-md-6 mt-1">
                                                    <div><label class="label-block"><?php echo e(__('Role')); ?></label></div>
                                                    <input type="text" name="role"
                                                        value="<?php echo e($role ? $role->name : 'Role Not Set'); ?>"
                                                        class="form-control" disabled>
                                                </div>
                                                <div class="col-md-6 mt-1">
                                                    <div><label class="label-block"><?php echo e(__('Status')); ?></label></div>
                                                    <select class="form-control" name="status" disabled>
                                                        <option value="active"
                                                            <?php echo e($user->status == 'active' ? 'SELECTED' : ''); ?>>
                                                            <?php echo e($user->status); ?></option>
                                                        <option value="active"
                                                            <?php echo e($user->status == 'banned' ? 'SELECTED' : ''); ?>>
                                                            <?php echo e($user->status); ?></option>
                                                    </select>
                                                </div>
                                                <div class="col-md-6 mb-1 mt-2">
                                                    <div><label class="label-block"><?php echo e(__('Full Name')); ?></label>
                                                    </div>
                                                    <input type="text" name="fullname" value="<?php echo e($user->name); ?>"
                                                        class="form-control">
                                                    <?php if($errors->has('fullname')): ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($errors->first('fullname')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="col-md-6 mt-1">
                                                    <div><label class="label-block"><?php echo e(__('Phone')); ?></label></div>
                                                    <input type="text" name="phone" value="<?php echo e($user->phone); ?>"
                                                        class="form-control" placeholder=<?php echo e(__('Phone')); ?>>
                                                    <?php if($errors->has('phone')): ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($errors->first('phone')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="col-md-6 mt-1">
                                                    <label for="mobile"><?php echo e(__('Country')); ?></label>
                                                    <select name="country" class="form-control form-control-inline-block">
                                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($country); ?>"
                                                                <?php echo e($user->country == $country ? 'selected' : ''); ?>>
                                                                <?php echo e($country); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($errors->has('country')): ?>
                                                            <span class="invalid-feedback" role="alert">
                                                                <strong><?php echo e($errors->first('country')); ?></strong>
                                                            </span>
                                                        <?php endif; ?>
                                                    </select>
                                                </div>
                                                <div class="col-sm-6 mt-1">
                                                    <label for="address"
                                                        class="control-label"><?php echo e(__('Address')); ?></label>
                                                    <input type="text" name="address" class="form-control"
                                                        value="<?php echo e($user->address); ?>" id="address"
                                                        placeholder=<?php echo e(__('Address')); ?>>
                                                    <?php if($errors->has('address')): ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($errors->first('address')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <div class="col-md-12 text-left">
                                                <button type="submit"
                                                    class="btn btn-primary col-sm-2"><?php echo e(__('Update Account')); ?></button>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="tab-pane" id="login-details" role="tabpanel"
                                        aria-labelledby="login-details-tab">
                                        <form class="form-horizontal" method="POST"
                                            action="<?php echo e(route('update-login', $user->id)); ?>">
                                            <?php echo csrf_field(); ?>
                                            <div class="row form-group">
                                                <div class="col-md-12">
                                                    <div><label class="label-block"><?php echo e(__('Email')); ?></label></div>
                                                    <input type="text" name="email" value="<?php echo e($user->email); ?>"
                                                        class="form-control">
                                                    <?php if($errors->has('email')): ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($errors->first('email')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="col-md-6 my-1">
                                                    <div><label class="label-block"><?php echo e(__('Password')); ?></label>
                                                    </div>
                                                    <input type="password" name="password" value=""
                                                        placeholder="<?php echo e(__('Leave blank if you dont want to change')); ?>"
                                                        class="form-control" autocomplete="off">
                                                    <?php if($errors->has('password')): ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($errors->first('password')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="col-md-6 my-1">
                                                    <div><label
                                                            class="label-block"><?php echo e(__('Confirm Password')); ?></label>
                                                    </div>
                                                    <input type="password" name="password_confirmation" value=""
                                                        placeholder="<?php echo e(__('Leave blank if you dont want to change')); ?>"
                                                        class="form-control" autocomplete="off">
                                                    <?php if($errors->has('password_confirmation')): ?>
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong><?php echo e($errors->first('password_confirmation')); ?></strong>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="col-md-12 text-left">
                                                <button type="submit"
                                                    class="btn btn-primary col-sm-2"><?php echo e(__('Update Login')); ?></button>
                                            </div>
                                        </form>
                                    </div>
                                    <?php if(extension_loaded('imagick') && setting('2fa')): ?>

                                        <div class="tab-pane" id="tfa-settings" role="tabpanel"
                                            aria-labelledby="tfa-settings-tab">
                                            <!--Google Two Factor Authentication card-->
                                            <div class="col-md-12">
                                                <?php echo $__env->make('layouts.includes.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                
                                                <?php if(empty(auth()->user()->loginSecurity)): ?>
                                                    <!--=============Generate QRCode for Google 2FA Authentication=============-->
                                                    <div class="row p-0">
                                                        <div class="col-md-12">
                                                            <p><?php echo e(__('To activate Two factor Authentication Generate QRCode')); ?>

                                                            </p>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <form class="" action="
                                                                    <?php echo e(route('generate2faSecret')); ?>" method="post">
                                                                <?php echo csrf_field(); ?>
                                                                <button
                                                                    class="btn btn-primary col-md-6"><?php echo e(__('Activate 2FA')); ?></button>
                                                                <a class="btn btn-secondary col-md-5" data-toggle="collapse"
                                                                    href="#collapseExample" role="button"
                                                                    aria-expanded="false"
                                                                    aria-controls="collapseExample"><?php echo e(__('Setup Instruction')); ?></a>
                                                            </form>
                                                        </div>
                                                        <div class="col-md-12 mt-3 collapse" id="collapseExample">
                                                            <hr>
                                                            <h3 class="">
                                                                <?php echo e(__('Two Factor Authentication(2FA) Setup Instruction')); ?>

                                                            </h3>
                                                            <hr>
                                                            <div
                                                                class="
                                                                mt-4">
                                                                <h4><?php echo e(__('Below is a step by step instruction on setting up Two Factor Authentication')); ?>

                                                                </h4>
                                                                <p><label><?php echo e(__('Step 1')); ?>:</label>
                                                                    <?php echo e(__('Download')); ?>

                                                                    <strong><?php echo e(__('Google Authenticator App')); ?></strong>
                                                                    <?php echo e(__('Application for Andriod or iOS')); ?>

                                                                </p>
                                                                <p class="text-center">
                                                                    <a href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en"
                                                                        target="_blank"
                                                                        class="btn btn-success"><?php echo e(__('Download for Andriod')); ?><i
                                                                            class="fa fa-android fa-2x ml-2"></i></a>
                                                                    <a href="https://apps.apple.com/us/app/google-authenticator/id388497605"
                                                                        target="_blank"
                                                                        class="btn btn-dark ml-2"><?php echo e(__('Download for iPhones')); ?><i
                                                                            class="fa fa-apple fa-2x ml-2"></i></a>
                                                                </p>
                                                                <p><label><?php echo e(__('Step 2')); ?>:</label>
                                                                    <?php echo e(__('Click on Generate Secret Key on the platform to generate a QRCode')); ?>

                                                                </p>
                                                                <p><label><?php echo e(__('Step 3')); ?>:</label>
                                                                    <?php echo e(__('Open the')); ?>

                                                                    <strong><?php echo e(__('Google Authenticator App')); ?></strong>
                                                                    <?php echo e(__('and clcik on')); ?>

                                                                    <strong><?php echo e(__('Begin')); ?></strong>
                                                                    <?php echo e(__('on the mobile app')); ?>

                                                                </p>
                                                                <p><label><?php echo e(__('Step 4')); ?>:</label>
                                                                    <?php echo e(__('After which click on')); ?>

                                                                    <strong><?php echo e(__('Scan a QRcode')); ?></strong>
                                                                </p>
                                                                <p><label><?php echo e(__('Step 5')); ?>:</label>
                                                                    <?php echo e(__('Then scan the barcode on the platform')); ?></p>
                                                                <p><label><?php echo e(__('Step 6')); ?>:</label>
                                                                    <?php echo e(__('Enter the verification code generated on the platform and Enable 2FA')); ?>

                                                                </p>
                                                                <hr>
                                                                <p><label><?php echo e(__('Note')); ?>:</label>
                                                                    <?php echo e(__('To disable 2FA enter code from the Google Authenticator App and account password to disable 2FA')); ?>

                                                                </p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!--=============Generate QRCode for Google 2FA Authentication=============-->
                                                <?php elseif(!auth()->user()->loginSecurity->google2fa_enable): ?>
                                                    <!--=============Enable Google 2FA Authentication=============-->
                                                    <form class="form-horizontal" method="POST"
                                                        action="<?php echo e(route('enable2fa')); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <p><strong><?php echo e(__('Scan the QRCode with')); ?>

                                                                        <dfn><?php echo e(__('Google Authenticator App')); ?></dfn>
                                                                        <?php echo e(__('Enter the generated code below')); ?></strong>
                                                                </p>
                                                            </div>
                                                            <div class="col-md-12"><img
                                                                    src="<?php echo e($google2fa_url); ?>" />
                                                            </div>
                                                            <div class="col-md-12">
                                                                <p><?php echo e(__('To enable 2-Factor Authentication verify QRCode')); ?>

                                                                </p>
                                                            </div>
                                                            <div class="col-sm-12">
                                                                <label for="address"
                                                                    class="control-label"><?php echo e(__('Verification code')); ?></label>
                                                                <input type="password" name="secret" class="form-control"
                                                                    id="code"
                                                                    placeholder="<?php echo e(__('Verification code')); ?>">
                                                                <?php if($errors->has('verify-code')): ?>
                                                                    <span class="invalid-feedback" role="alert">
                                                                        <strong><?php echo e($errors->first('verify-code')); ?></strong>
                                                                    </span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12 text-left">
                                                            <button type="submit"
                                                                class="btn btn-primary col-sm-2"><?php echo e(__('Enable 2FA')); ?></button>
                                                        </div>
                                                    </form>
                                                    <!--=============Enable Google 2FA Authentication=============-->
                                                <?php elseif(auth()->user()->loginSecurity->google2fa_enable): ?>
                                                    <!--=============Disable Google 2FA Authentication=============-->
                                                    <form class="form-horizontal" method="POST"
                                                        action="<?php echo e(route('disable2fa')); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="row">
                                                            <div class="col-md-12"><img
                                                                    src="<?php echo e($google2fa_url); ?>" />
                                                            </div>
                                                            <div class="col-md-12">
                                                                <p><?php echo e(__('To disable 2-Factor Authentication verify QRCode')); ?>

                                                                </p>
                                                            </div>
                                                            <div class="col-sm-12">
                                                                <label for="address"
                                                                    class="control-label"><?php echo e(__('Current Password')); ?></label>
                                                                <input id="password" type="password"
                                                                    placeholder="<?php echo e(__('Current Password')); ?>"
                                                                    class="form-control<?php echo e($errors->has('password') ? ' is-invalid' : ''); ?>"
                                                                    name="current-password" required>
                                                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <span class="invalid-feedback" role="alert">
                                                                        <strong><?php echo e($error('password')); ?></strong>
                                                                    </span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12 text-left">
                                                            <button type="submit"
                                                                class="btn btn-danger col-sm-2"><?php echo e(__('Disable 2FA')); ?></button>
                                                        </div>
                                                    </form>
                                                    <!--=============Disable Google 2FA Authentication=============-->
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('assets/js/custom.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\virtual_card\resources\views/profile/index.blade.php ENDPATH**/ ?>