<?php $__env->startSection('title', $t); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e($t); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>">Dashboard</a></div>
                    <div class="breadcrumb-item"><a href="<?php echo e(route('settings')); ?>"><?php echo e(__('Settings')); ?></a></div>
                    <div class="breadcrumb-item"><?php echo e($t); ?></div>
                </div>
            </div>
            <div class="section-body">
                <h2 class="section-title">All About <?php echo e($t); ?></h2>
                <p class="section-lead">
                    You can adjust all <?php echo e($t); ?> here
                </p>
                <div id="output-status"></div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h4>Jump To</h4>
                            </div>
                            <div class="card-body">
                                <ul class="nav nav-pills flex-column">
                                    <li class="nav-item"><a href="<?php echo e(route('setting', 'app-setting')); ?>"
                                            class="nav-link ">App Setting</a></li>
                                    <li class="nav-item"><a href="<?php echo e(route('setting', 'general-setting')); ?>"
                                            class="nav-link active">General</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <form id="setting-form" action="<?php echo e(route('settings/auth-settings/update')); ?>"
                            enctype="multipart/form-data" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="card" id="settings-card">
                                <div class="card-header">
                                    <h4> <?php echo e($t); ?></h4>
                                </div>
                                <div class="card-body">
                                    
                                   
                                    <div class="form-group">
                                        <label for="date_format"><?php echo e(__('Date Format')); ?></label>
                                        <select name="date_format" class="form-control">
                                            <option value="M j, Y" <?php echo e(Utility::getsettings('date_format') == 'M j, Y' ? 'selected' : ''); ?>><?php echo e(__('Jan 1, 2020')); ?></option>
                                                <option value="d-M-y" <?php echo e(Utility::getsettings('date_format') == 'd-M-y' ? 'selected' : ''); ?>><?php echo e(__('01-Jan-20')); ?></option>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label for="time_format"><?php echo e(__('Time Format')); ?></label>
                                                <select name="time_format" class="form-control">
                                                    <option value="g:i A" <?php echo e(Utility::getsettings('time_format') == 'g:i A' ? 'selected' : ''); ?>><?php echo e(__('hh:mm AM/PM')); ?></option>
                                                        <option value="H:i:s" <?php echo e(Utility::getsettings('time_format') == 'H:i:s' ? 'selected' : ''); ?>><?php echo e(__('HH:mm:ss')); ?></option>
                                                        </select>
                                                    </div>
                                                </div>  
                                <div class="card-footer bg-whitesmoke text-md-right">
                                    <button class="btn btn-primary" type="submit" id="save-btn"><?php echo e(__('Save Changes')); ?></button>
                                    <a href="<?php echo e(route('settings')); ?>" class="btn btn-secondary"><?php echo e(__('Cancel')); ?></a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\virtual_card\resources\views/settings/general-setting.blade.php ENDPATH**/ ?>