<?php $__env->startSection('title', 'Users'); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Create User</h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>">Dashboard</a></div>
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('users.index')); ?>">Users</a></div>
                    <div class="breadcrumb-item">Create User</div>
                </div>
            </div>
            <div class="section-body">
                <div class="row">
                    <div class="col-md-8 m-auto">
                        <div class="card p-4">
                            <?php echo Form::open(['route' => 'send.notification', 'method' => 'Post', 'enctype' => 'multipart/form-data']); ?>

                            <div class="row">
                                <div class="form-group col-md-6">
                                    <?php echo e(Form::label('name', __('Title'))); ?>

                                    <div class="input-group ">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fas fa-user"></i>
                                            </div>
                                        </div>
                                        <?php echo Form::text('title', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Title']); ?>

                                    </div>
                                </div>
                                <div class="form-group col-md-6 ">
                                    <?php echo e(Form::label('user_id', __('User ID'))); ?>

                                    <div class="input-group ">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="fas fa-user"></i>
                                            </div>
                                        </div>
                                        <?php echo Form::textarea('message', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter message']); ?>

                                    </div>
                                </div>
                            </div>
                            

                            
                            <div class="btn-flt">
                                <a href="<?php echo e(route('users.index')); ?>" class="btn btn-secondary"><?php echo e(__('Cancel')); ?></a>
                                <button type="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                            </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('javascript'); ?>
    <script src="https://www.gstatic.com/firebasejs/7.23.0/firebase.js"></script>
<script>
  
    var firebaseConfig = {
        apiKey: "AIzaSyCWiQzfs3JepkNYllqQu2euMLqOVrRSWzw",
        authDomain: "aglowid-datingapp.firebaseapp.com",
        databaseURL: "https://aglowid-datingapp.firebaseio.com",
        projectId: "aglowid-datingapp",
        storageBucket: "aglowid-datingapp.appspot.com",
        messagingSenderId: "594594534149",
        appId: "1:594594534149:web:38a77a58b8ab8694ef1d6c",
        measurementId: "G-CXZNXLRRFJ"
    };
      
    firebase.initializeApp(firebaseConfig);
    const messaging = firebase.messaging();
  
    function initFirebaseMessagingRegistration() {
            messaging
            .requestPermission()
            .then(function () {
                return messaging.getToken()
            })
            .then(function(token) {
                console.log(token);
   
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
  
                $.ajax({
                    url: '<?php echo e(route("save-token")); ?>',
                    type: 'POST',
                    data: {
                        token: token
                    },
                    dataType: 'JSON',
                    success: function (response) {
                        alert('Token saved successfully.');
                    },
                    error: function (err) {
                        console.log('User Chat Token Error'+ err);
                    },
                });
  
            }).catch(function (err) {
                console.log('User Chat Token Error'+ err);
            });
     }  
      
    messaging.onMessage(function(payload) {
        const noteTitle = payload.notification.title;
        const noteOptions = {
            body: payload.notification.body,
            icon: payload.notification.icon,
        };
        new Notification(noteTitle, noteOptions);
    });
   
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\virtual_card\resources\views/users/noti.blade.php ENDPATH**/ ?>